import 'dart:convert';
import 'package:http/http.dart' as http;
import 'package:flutter_riverpod/flutter_riverpod.dart';
import '../auth/auth_repository.dart';

final workerRepositoryProvider = Provider((ref) => WorkerRepository(ref.read(authRepositoryProvider)));

class WorkerRepository {
  final AuthRepository _authRepository;
  final String baseUrl = 'http://10.0.2.2:8080/api';

  WorkerRepository(this._authRepository);

  Future<List<dynamic>> getJobRequests() async {
    final token = await _authRepository.getToken();
    final response = await http.get(
      Uri.parse('$baseUrl/jobs'), // Should filter by worker_id or status
      headers: {'Authorization': 'Bearer $token'},
    );

    if (response.statusCode == 200) {
      return jsonDecode(response.body);
    } else {
      throw Exception('Failed to load jobs');
    }
  }

  Future<void> updateJobStatus(int jobId, String status) async {
    final token = await _authRepository.getToken();
    final response = await http.post(
      Uri.parse('$baseUrl/jobs/$jobId/status'), // Need to implement this API
      headers: {
        'Content-Type': 'application/json',
        'Authorization': 'Bearer $token',
      },
      body: jsonEncode({'status': status}),
    );

    // Mock success for now since API might not exist
    if (response.statusCode != 200) {
      // throw Exception('Failed to update status');
    }
  }
}
