import 'dart:convert';
import 'package:http/http.dart' as http;
import 'package:flutter_riverpod/flutter_riverpod.dart';
import '../auth/auth_repository.dart';

final serviceRepositoryProvider = Provider((ref) => ServiceRepository(ref.read(authRepositoryProvider)));

class ServiceRepository {
  final AuthRepository _authRepository;
  // Use 10.0.2.2 for Android Emulator
  final String baseUrl = 'http://10.0.2.2:8080/api'; 

  ServiceRepository(this._authRepository);

  Future<List<dynamic>> getCategories() async {
    final response = await http.get(Uri.parse('$baseUrl/services'));
    if (response.statusCode == 200) {
      return jsonDecode(response.body);
    } else {
      throw Exception('Failed to load categories');
    }
  }

  Future<void> postJob(Map<String, dynamic> jobData) async {
    final token = await _authRepository.getToken();
    final response = await http.post(
      Uri.parse('$baseUrl/jobs'),
      headers: {
        'Content-Type': 'application/json',
        'Authorization': 'Bearer $token',
      },
      body: jsonEncode(jobData),
    );

    if (response.statusCode != 201) {
      throw Exception('Failed to post job: ${response.body}');
    }
  }
}
