import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/foundation.dart';

class FCMService {
  final _firebaseMessaging = FirebaseMessaging.instance;

  Future<void> initNotifications() async {
    await _firebaseMessaging.requestPermission();
    
    final fCMToken = await _firebaseMessaging.getToken();
    if (kDebugMode) {
      print('FCM Token: $fCMToken');
    }

    // TODO: Send token to backend via API
    // await authRepository.updateFCMToken(fCMToken);

    FirebaseMessaging.onMessage.listen((RemoteMessage message) {
      if (kDebugMode) {
        print('Got a message whilst in the foreground!');
        print('Message data: ${message.data}');

        if (message.notification != null) {
          print('Message also contained a notification: ${message.notification}');
        }
      }
    });
  }
}
