# cPanel Deployment Guide for Blixora

## 1. Backend (CodeIgniter 4)

### Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Composer (optional, if vendor folder is uploaded)

### Steps
1. **Upload Files**:
   - Zip the `backend` folder.
   - Upload to `public_html` (or a subdomain folder) via File Manager.
   - Extract the zip.

2. **Configure Database**:
   - Create a MySQL Database and User in cPanel.
   - Import `docs/schema.sql` via phpMyAdmin.
   - Edit `backend/.env` (rename `env` to `.env` if needed):
     ```ini
     CI_ENVIRONMENT = production
     app.baseURL = 'https://yourdomain.com/'
     database.default.hostname = localhost
     database.default.database = your_db_name
     database.default.username = your_db_user
     database.default.password = your_db_pass
     ```

3. **Set Permissions**:
   - Ensure `writable` folder is 777 or 755.

4. **Public Folder**:
   - Move contents of `backend/public` to `public_html` (if deploying to root).
   - Update `index.php` to point to the correct `app` path:
     ```php
     $pathsPath = FCPATH . '../backend/app/Config/Paths.php';
     ```

5. **Cron Jobs**:
   - Add the following Cron Jobs in cPanel:
     ```bash
     # Process Queue (Every Minute)
     /usr/local/bin/php /home/username/public_html/backend/spark cron processQueue

     # Cleanup (Every Hour)
     /usr/local/bin/php /home/username/public_html/backend/spark cron cleanup
     ```

## 2. Mobile App (Flutter)

### Build
1. **Android**:
   ```bash
   flutter build apk --release
   ```
2. **iOS** (Requires Mac):
   ```bash
   flutter build ios --release
   ```

### Configuration
- Update `baseUrl` in `auth_repository.dart`, `service_repository.dart`, and `worker_repository.dart` to your live domain (e.g., `https://yourdomain.com/api`).
- Generate `google-services.json` (Android) and `GoogleService-Info.plist` (iOS) from Firebase Console and place in `android/app` and `ios/Runner` respectively.

## 3. Admin & Website
- These are part of the Backend deployment.
- Access Admin at `https://yourdomain.com/admin/dashboard`.
- Access Website at `https://yourdomain.com/`.
