<?= $this->include('admin/layout/header') ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">User Management</h1>
</div>

<?php if (session()->getFlashdata('message')): ?>
    <div class="alert alert-success"><?= session()->getFlashdata('message') ?></div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger"><?= session()->getFlashdata('error') ?></div>
<?php endif; ?>

<div class="table-responsive">
    <table class="table table-striped table-sm">
        <thead>
            <tr>
                <th>ID</th>
                <th>Phone</th>
                <th>Role</th>
                <th>Status</th>
                <th>KYC Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
            <tr>
                <td><?= $user['id'] ?></td>
                <td><?= $user['phone'] ?></td>
                <td><?= ucfirst($user['role']) ?></td>
                <td><?= $user['is_verified'] ? 'Verified' : 'Unverified' ?></td>
                <td>
                    <?php if ($user['role'] == 'worker'): ?>
                        <span class="badge bg-<?= $user['kyc_status'] == 'approved' ? 'success' : ($user['kyc_status'] == 'rejected' ? 'danger' : 'warning') ?>">
                            <?= ucfirst($user['kyc_status'] ?? 'N/A') ?>
                        </span>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
                <td>
                    <?php if ($user['role'] == 'worker' && ($user['kyc_status'] == 'pending' || $user['kyc_status'] == 'rejected')): ?>
                        <a href="/admin/users/approve/<?= $user['id'] ?>" class="btn btn-sm btn-success">Approve</a>
                        <a href="/admin/users/reject/<?= $user['id'] ?>" class="btn btn-sm btn-danger">Reject</a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?= $this->include('admin/layout/footer') ?>
