<?= $this->include('admin/layout/header') ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Job Monitoring</h1>
</div>

<div class="table-responsive">
    <table class="table table-striped table-sm">
        <thead>
            <tr>
                <th>ID</th>
                <th>Service</th>
                <th>Customer</th>
                <th>Worker</th>
                <th>Status</th>
                <th>Price</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($jobs as $job): ?>
            <tr>
                <td><?= $job['id'] ?></td>
                <td><?= $job['service_name'] ?></td>
                <td><?= $job['customer_phone'] ?></td>
                <td><?= $job['worker_phone'] ?? 'Pending' ?></td>
                <td>
                    <span class="badge bg-<?= $job['status'] == 'completed' ? 'success' : ($job['status'] == 'cancelled' ? 'danger' : 'primary') ?>">
                        <?= ucfirst($job['status']) ?>
                    </span>
                </td>
                <td><?= $job['price'] ?></td>
                <td><?= $job['created_at'] ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?= $this->include('admin/layout/footer') ?>
