<?= $this->include('admin/layout/header') ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Financial Reporting</h1>
</div>

<div class="table-responsive">
    <table class="table table-striped table-sm">
        <thead>
            <tr>
                <th>ID</th>
                <th>Job ID</th>
                <th>Amount</th>
                <th>Gateway</th>
                <th>Transaction ID</th>
                <th>Status</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($payments as $payment): ?>
            <tr>
                <td><?= $payment['id'] ?></td>
                <td><?= $payment['job_id'] ?></td>
                <td><?= $payment['amount'] ?> <?= $payment['currency'] ?></td>
                <td><?= ucfirst($payment['gateway']) ?></td>
                <td><?= $payment['transaction_id'] ?></td>
                <td>
                    <span class="badge bg-<?= $payment['status'] == 'success' ? 'success' : ($payment['status'] == 'failed' ? 'danger' : 'warning') ?>">
                        <?= ucfirst($payment['status']) ?>
                    </span>
                </td>
                <td><?= $payment['created_at'] ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?= $this->include('admin/layout/footer') ?>
