<?php

namespace App\Models;

use CodeIgniter\Model;

class JobModel extends Model
{
    protected $table            = 'jobs';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $allowedFields    = [
        'customer_id', 'worker_id', 'service_id', 'status', 'price', 
        'location_address', 'location_lat', 'location_lng', 
        'scheduled_time', 'notes', 'otp_start', 'otp_end'
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules = [
        'customer_id' => 'required|integer',
        'service_id'  => 'required|integer',
        'location_lat' => 'required|decimal',
        'location_lng' => 'required|decimal',
    ];
}
