<?php

namespace App\Controllers;

use CodeIgniter\RESTful\ResourceController;
use App\Models\CategoryModel;
use App\Models\ServiceModel;

class Services extends ResourceController
{
    public function index()
    {
        // Get all categories with their services
        $categoryModel = new CategoryModel();
        $serviceModel = new ServiceModel();

        $categories = $categoryModel->where('is_active', 1)->findAll();
        $data = [];

        foreach ($categories as $category) {
            $services = $serviceModel->where('category_id', $category['id'])->where('is_active', 1)->findAll();
            $category['services'] = $services;
            $data[] = $category;
        }

        return $this->respond($data);
    }

    public function show($id = null)
    {
        $serviceModel = new ServiceModel();
        $data = $serviceModel->find($id);
        if (!$data) {
            return $this->failNotFound('Service not found');
        }
        return $this->respond($data);
    }
}
