<?php

namespace App\Controllers\Admin;

use App\Models\UserModel;
use App\Models\WorkerProfileModel;

class Users extends AdminBaseController
{
    public function index()
    {
        $userModel = new UserModel();
        // Join with worker profiles to get KYC status
        $users = $userModel->select('users.*, worker_profiles.kyc_status')
                           ->join('worker_profiles', 'worker_profiles.user_id = users.id', 'left')
                           ->findAll();

        return view('admin/users/index', ['users' => $users]);
    }

    public function approve($userId)
    {
        $workerModel = new WorkerProfileModel();
        $workerModel->update($userId, ['kyc_status' => 'approved', 'is_online' => 1]);
        
        // Update main user table verification
        $userModel = new UserModel();
        $userModel->update($userId, ['is_verified' => 1]);

        return redirect()->to('/admin/users')->with('message', 'Worker Approved');
    }

    public function reject($userId)
    {
        $workerModel = new WorkerProfileModel();
        $workerModel->update($userId, ['kyc_status' => 'rejected']);

        return redirect()->to('/admin/users')->with('error', 'Worker Rejected');
    }
}
