<?php

namespace App\Controllers\Admin;

use App\Models\JobModel;

class Jobs extends AdminBaseController
{
    public function index()
    {
        $jobModel = new JobModel();
        $jobs = $jobModel->select('jobs.*, services.name as service_name, c.phone as customer_phone, w.phone as worker_phone')
                         ->join('services', 'services.id = jobs.service_id')
                         ->join('users c', 'c.id = jobs.customer_id')
                         ->join('users w', 'w.id = jobs.worker_id', 'left')
                         ->orderBy('created_at', 'DESC')
                         ->findAll();

        return view('admin/jobs/index', ['jobs' => $jobs]);
    }
}
