<?php

namespace App\Controllers\Admin;

use App\Models\PaymentModel;

class Finance extends AdminBaseController
{
    public function index()
    {
        $paymentModel = new PaymentModel();
        $payments = $paymentModel->select('payments.*, jobs.id as job_id, jobs.customer_id, jobs.worker_id')
                                 ->join('jobs', 'jobs.id = payments.job_id')
                                 ->orderBy('created_at', 'DESC')
                                 ->findAll();

        return view('admin/finance/index', ['payments' => $payments]);
    }
}
