<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

$routes->group('api', function($routes) {
    // Auth Routes
    $routes->post('auth/register', 'Auth::register');
    $routes->post('auth/login', 'Auth::login');

    // Public Routes
    $routes->get('services', 'Services::index');
    $routes->get('services/(:num)', 'Services::show/$1');

    // Protected Routes
    $routes->group('', ['filter' => 'auth'], function($routes) {
        $routes->get('user/profile', 'User::profile');
        
        // Jobs
        $routes->post('jobs', 'Jobs::create');
        $routes->get('jobs', 'Jobs::index');
        $routes->get('jobs/(:num)', 'Jobs::show/$1');

        // Payments
        $routes->post('payments/initiate', 'Payments::initiate');
    });

    // Webhooks (Public)
    $routes->post('webhooks/payment', 'Payments::webhook');
});

// Cron Routes (CLI or Restricted)
$routes->cli('cron/processQueue', 'Cron::processQueue');
$routes->cli('cron/cleanup', 'Cron::cleanup');
$routes->get('cron/processQueue', 'Cron::processQueue'); // For cPanel URL cron
$routes->get('cron/cleanup', 'Cron::cleanup');

// Admin Routes
$routes->group('admin', ['namespace' => 'App\Controllers\Admin'], function($routes) {
    $routes->get('dashboard', 'Dashboard::index');
    $routes->get('users', 'Users::index');
    $routes->get('users/approve/(:num)', 'Users::approve/$1');
    $routes->get('users/reject/(:num)', 'Users::reject/$1');
    $routes->get('jobs', 'Jobs::index');
    $routes->get('finance', 'Finance::index');
});
